## R has a predefined dataset with the name "chickwts"
  # To know more about the dataset type "?chickwts" in the console

# 1) Creating training and testing data from "chickwts" dataset
  # 1.1) Generating Random Numbers
  set.seed(100)
  # 1.2) Creating sample for splitting the dataset
  Sample <- sample(nrow(chickwts),0.7*nrow(chickwts))
  # 1.3) Training dataset contains 70% of data
  Training <- chickwts[Sample,]
  # 1.4) Testing dataset contains 30% of data
  Testing <- chickwts[-Sample,]
  
# 2) Normalizing data
  # 2.1) Normalizing training data
  Training[,1] <- scale(Training[,1])
  # 2.2) Normalizing testing data
  Testing[,1] <- scale(Testing[,1])
  
# 3) Labelling feed
  # 3.1) Labelling feed for training data
  Training$feed <- as.integer(factor(Training$feed))
  # 3.2) Labelling feed for testing data
  Testing$feed <- as.integer(factor(Testing$feed))
  
# 4) Creating a Linear Regression model and predicting values
  # 4.1) Applying Linear Regression
  Model <- lm(feed~weight,data = Training)
  # 4.2) Predicting feed
  Prediction <- as.data.frame(predict(Model,Testing,interval='confidence'))
  
# 5) Plotting Predictions
  plot(Testing$feed,main = "Actual v/s Predicted Feed",ylab = "",xlab = "")
  # 5.1) Adding a line to represent Upper Limit of prediction
  lines(Prediction$upr,lty = 1)
  # 5.2) Adding a line to represent Best Fit of prediction
  lines(Prediction$fit,lty = 2)
  # 5.3) Adding a line to represent Lower Limit of prediction
  lines(Prediction$lwr,lty = 3)
  # 5.4) Clipping legend to the figure region instead of the plot region
  par(xpd=TRUE)
  # 5.5) Adding a legend
  legend(2,-0.60,legend=c("Actual","Upper Limit","Predicted","Lower Limit"),
         pch = c(1,NA,NA,NA) ,lty = c(NA,1,2,3) , cex=0.8, horiz=T, inset = c(0,0),
         xpd = TRUE)
  # 5.6) Setting and adjusting labels of x and y axes
  title(ylab="Feed",xlab="Index", line=2.25, cex.lab=1)
  
# 6) The Significance of resultant Linear Model
  summary.lm(Model)
  
# 7) Confidence Interval
  # 7.1) Printing Confidence Interval values
  print(Prediction$upr-Prediction$lwr)
  # 7.2) Plotting Confidence Interval
  plot(Prediction$upr-Prediction$lwr,main = "Confidence Interval",
       type = "b",ylab = "",xlab = "")
  # 7.3) Setting and adjusting labels of x and y axes
  title(ylab = "Interval",xlab="Index", line=2.25, cex.lab=1)